/** @file   AStarAlgorithm.h
 * @brief   Declaration of AStarAlgorithm class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/02/24 12:21:19 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_ASTARALGORITHM_H
#define H_ENG2D_ASTARALGORITHM_H

#include "eng2d_dll.h"
#include "PathFinderAlgo.h"


namespace eng2d {

/** @class  AStarAlgorithm
 * @brief   Implements the A* path finding algorithm.
 * @author  Tomi Lamminsaari
 *
 * A* is computationally optimal path finding algorithm. In game programming
 * in mind, it is the most useful algorithm when calculating route between
 * two nodes. This class implements the MPathFinderAlgo interface.
 *
 * This implementation is not dependent on the map system you have. You can
 * use it with almost any kind of 2d maps. This class uses the MMapDataProvider
 * interface to query map related information so all you have to do is to
 * write your own class that implements the MMapDataProvider interface that
 * translates your map data to a form needed by this algorithm.
 */
class DLLIMPORT AStarAlgorithm : public MPathFinderAlgo
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   * @param   aMapProvider      Reference to object that provides the map
   *                            data to the path finding algorithm.
   */
  AStarAlgorithm( MMapDataProvider& aMapProvider );

  /** Destructor
   */
  virtual ~AStarAlgorithm();

private:
  AStarAlgorithm( const AStarAlgorithm& aAnother );
  AStarAlgorithm& operator= ( const AStarAlgorithm& aAnother );
public:


  ///
  /// Inherited methods
  /// =================

  /** From MPathFinderAlgo
   */
  virtual bool FindPath( const Vec2D& aStart, const Vec2D& aGoal );
  
  /** From MPathFinderAlgo
   */
  virtual const NodeArray& GetPathNodes() const;
  
  /** From MPathFinderAlgo
   */
  virtual void ResetPath();
  

  ///
  /// New public methods
  /// ==================

  /** Sets the upper limit of how many nodes the found route could have. By
   * default the number is 250 nodes. If the route from beginning node to
   * goal node takes more nodes, the algorithm gives up and tells that there
   * is no route.
   * @param   aMaxNodes         Maximum number of nodes the route could have.
   */
  void SetMaxRouteNodes( int aMaxNodes );


  ///
  /// Getter methods
  /// ==============


protected:
  ///
  /// Protected interface
  /// ===================


protected:
  ///
  /// Data members
  /// ============
  
  /** Reference to object that provides the map data. */
  MMapDataProvider& iMapProvider;
  /** Maximum number of nodes the route could have. */
  int iMaxNodes;
  /** Array for the path nodes. */
  MPathFinderAlgo::NodeArray iPath;
};

};  // end of namespace

#endif
